<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van PRPM_IN907110NL02 - Get AssignedDevice Details Response</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>
    
    <pattern is-a="transmission-wrapper" id="PRPM_IN907110NL02-wrapper">
        <param name="element" value="hl7:PRPM_IN907110NL02"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="PRPM_IN907110NL02-controlAct">
        <param name="element" value="hl7:PRPM_IN907110NL02/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:PRPM_IN907110NL02/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:PRPM_IN907110NL02/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
        <rule context="hl7:PRPM_IN907110NL02/hl7:attentionLine">
            <assert role="warning" test="not(.)">Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <!-- sender -->
        <rule context="hl7:PRPM_IN907110NL02/hl7:sender/hl7:device/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"
                >De zender van deze interactie moet een AORTA applicatie zijn, en moet de ZIM zijn</assert>
        </rule>
        <!-- receiver -->
        <rule context="hl7:PRPM_IN907110NL02/hl7:receiver/hl7:device/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1')"
                >De ontvanger van deze interactie moet een AORTA applicatie zijn, en kan niet de ZIM zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>registrationProcess</title>
        <rule context="hl7:subject/hl7:registrationProcess">
            <assert role="error" test="not(@classCode) or @classCode='REG'"
                >registrationProcess/@classCode moet 'REG' zijn</assert>
            <assert role="error" test="not(hl7:subject2)"
                >registrationProcess/subject2 is niet toegestaan in het Applicatieregister</assert>
            <assert role="error" test="count(hl7:subject1)=1"
                >registrationProcess/subject1 is moet exact één maal voorkomen. Registraties van meer dan één Applicatie zijn niet toegestaan</assert>
        </rule>
        
        <title>registrationProcess/statusCode</title>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:statusCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='active'">De statuscode moet 'active' zijn.</assert>
        </rule>
        
        <title>registrationProcess/code</title>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:code">
            <extends rule="CV"/>
            <assert role="error" test="@code='302850' and @codeSystem='2.16.840.1.113883.2.4.15.4'">registrationProcess/@code moet '302850' zijn en komen uit
                '2.16.840.1.113883.2.4.15.4' (ActRegistryNL)</assert>
        </rule>
        
        <title>registrationProcess/effectiveTime</title>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:effectiveTime">
            <extends rule="IVL_TS"/>
            <assert role="error" test="../../../../hl7:sender/hl7:device/hl7:id[@root='2.16.840.1.113883.2.4.6.6' and @extension='1'] or @nullFlavor='UNK'"
                >registrationProcess/effectiveTime/@nullFlavor moet 'UNK' zijn en er mogen geen andere attributen zijn gevuld, tenzij de afzender de ZIM is</assert>
            <assert role="error" test="not(../../../../hl7:sender/hl7:device/hl7:id[@root='2.16.840.1.113883.2.4.6.6' and @extension='1']) or 
                (not(@nullFlavor) and hl7:*)">registrationProcess/effectiveTime moet een waarde hebben indien de afzender de ZIM is (signalering)</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subject1/assignedDevice</title>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:subject1/hl7:assignedDevice/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6'"
                >assignedDevice/id/@root moet '2.16.840.1.113883.2.4.6.6' bevatten</assert>
        </rule>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:subject1/hl7:assignedDevice/hl7:telecom">
            <extends rule="TEL"/>
            <assert role="error" test="matches(@value,'^https?://[^/]+$')"
                >assignedDevice/telecom/@value moet URI-scheme http of https hebben en verder alleen hostnaam of ip-adres en eventueel een poortnummer bevatten</assert>
            <assert role="error" test="matches(@value,'^https?://[^:]+(:[0-9]+)?/?$')"
                >assignedDevice/telecom/@value moet, indien aanwezig, een numeriek poortnummer hebben</assert>
        </rule>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:subject1/hl7:assignedDevice/hl7:statusCode">
            <extends rule="CS"/>
            <assert role="error"
                test="@code='active' or @code='suspended' or @code='terminated'"
                >assignedDevice/statusCode mag alleen 'active', 'suspended', of 'terminated' bevatten</assert>
            <assert role="error" test="if (@code='suspended') then (
                ../hl7:subjectOf/hl7:detectedIssueEvent ) else ( 1=1 )"
                >subjectOf1/detectedIssue is verplicht indien assignedDevice/statusCode 'suspended' is</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subject1/assignedDevice/part/qualifiedApplicationRole</title>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:subject1/hl7:assignedDevice/hl7:part/hl7:qualifiedApplicationRole/hl7:code">
            <extends rule="CE"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.3.11.3'"
                >qualifiedApplicationRole/code moet komen uit '2.16.840.1.113883.2.4.3.11.3'</assert>
        </rule>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:subject1/hl7:assignedDevice/hl7:part/hl7:qualifiedApplicationRole/hl7:statusCode">
            <extends rule="CS"/>
            <assert role="error"
                test="@code='active' or @code='suspended' or @code='terminated'"
                >qualifiedApplicationRole/statusCode mag alleen 'active', 'suspended' of 'terminated' bevatten</assert>
            <assert role="error" test="if (@code='suspended') then (../hl7:subjectOf1) else (not(../hl7:subjectOf1))"
                >Als qualifiedApplicationRole/statusCode 'suspended' bevat, dan moet er ook een reden zijn, anders kan er geen reden zijn.</assert>
            <assert role="warning" test="if (@code='active') then (../hl7:subjectOf2) else ( 1=1 )"
                >subjectOf2/verficationEvent is verplicht indien qualifiedApplicationRole/statusCode 'active' is en de ontvanger deel is van de zorgaanbieder waar de huidige applicatie deel van uitmaakt</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subject1/assignedDevice/part/qualifiedApplicationRole/subjectOf1/detectedIssueEvent</title>
        <title>subject1/assignedDevice/subjectOf/detectedIssueEvent</title>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:subject1/hl7:assignedDevice//hl7:detectedIssueEvent">
            <assert role="error" test="../../hl7:statusCode[@code='suspended']"
                >detectedIssueEvent kan er alleen zijn als de <value-of select="local-name(../..)"/>/statusCode op 'suspended' staat</assert>
        </rule>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:subject1/hl7:assignedDevice//hl7:detectedIssueEvent/hl7:code">
            <extends rule="CV"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.5.4'"
                >detectedIssueEvent/code moet komen uit '2.16.840.1.113883.5.4' (ActCode)</assert>
            <assert role="error" test="@code='ISSUEMNT' or @code='ISSUEPRB'"
                >detectedIssueEvent/code moet één van ISSUEMNT ISSUEPRB zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subject1/assignedDevice/part/qualifiedApplicationRole/subjectOf2/verficationEvent</title>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:subject1/hl7:assignedDevice/hl7:part/hl7:qualifiedApplicationRole/hl7:subjectOf2/hl7:verficationEvent/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.5'"
                >verficationEvent/id moet '2.16.840.1.113883.2.4.3.11.5' (XIS-typekwalificatie-id) zijn</assert>
        </rule>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:subject1/hl7:assignedDevice/hl7:part/hl7:qualifiedApplicationRole/hl7:subjectOf2/hl7:verficationEvent/hl7:code">
            <extends rule="CV"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.3.11.2' and @code='XTK'"
                >verficationEvent/code moet 'XTK' zijn en komen uit '2.16.840.1.113883.2.4.3.11.2' (XIS-typekwalificatietypen)</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subject1/assignedDevice/part/qualifiedApplicationRole/reusableDeviceOf/informEvent</title>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:subject1/hl7:assignedDevice/hl7:qualifiedApplicationRole/hl7:reusableDeviceOf/hl7:informEvent/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.1.6'"
                >informEvent/id moet komen uit '2.16.840.1.113883.1.6' (InteractionId's)</assert>
        </rule>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:subject1/hl7:assignedDevice/hl7:qualifiedApplicationRole/hl7:reusableDeviceOf/hl7:informEvent/hl7:code">
            <extends rule="CV"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.5.4'"
                >informEvent/code moet komen uit '2.16.840.1.113883.5.4' (ActCode)</assert>
            <assert role="error" test="@code='DIRSEND' or @code='DIRREC' or @code='BIDIR'"
                >informEvent/code moet één van DIRREC, DIRSEND of BIDIR zijn</assert>
        </rule>
    </pattern>
        
    <pattern>
        <title>subject1/assignedDevice/related/assignedEntity</title>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:subject1/hl7:assignedDevice/hl7:related/hl7:assignedEntity/hl7:id">
            <extends rule="II"/>
            <assert role="warning" test="@root='2.16.528.1.1007.3.3' or (@root='2.16.840.1.113883.2.4.3.11' and @extension='7') or @root='2.16.840.1.113883.2.4.3.11.25' or @root='2.16.840.1.113883.2.4.3.11.10'"
                ><name path=".."/>/<name/> is onbekend (@root='<value-of select="@root"/>' @extension='<value-of select="@extension"/>'). Verwachte waarden zijn '2.16.528.1.1007.3.3' (URA), '2.16.840.1.113883.2.4.3.11' / '7' (Klantenloket), '2.16.840.1.113883.2.4.3.11.25' (GBO/GBP), '2.16.840.1.113883.2.4.3.11.10' (organisatiedelen)</assert>
        </rule>
    </pattern>
</schema>
